import os
import json
import subprocess
import webbrowser
import getpass

DATA_FILE = 'users.json'

def clear():
    os.system('cls' if os.name == 'nt' else 'clear')

def pause():
    input("\nPress Enter to continue...")

def load_users():
    if os.path.exists(DATA_FILE):
        with open(DATA_FILE, 'r') as f:
            return json.load(f)
    return {}

def save_users(users):
    with open(DATA_FILE, 'w') as f:
        json.dump(users, f, indent=4)

def print_border(title=""):
    border_line = "═" * 50
    print(f"╔{border_line}╗")
    if title:
        print(f"║{title.center(50)}║")
    print(f"╚{border_line}╝")

def print_header():
    clear()
    print_border("Triumphant OS")
    print()

def register_user(users):
    print_header()
    print("Register New User")
    username = input("Username: ").strip()
    if len(users) >= 100000000000000000:
        print("Maximum user limit reached.")
        pause()
        return users
    if username in users:
        print("User already exists.")
        pause()
        return users
    password = input("Password: ").strip()
    users[username] = {"password": password, "settings": {}}
    save_users(users)
    print(f"User '{username}' registered successfully.")
    pause()
    return users

def login_user(users):
    print_header()
    print("Login")
    username = input("Username: ").strip()
    password = getpass.getpass("Password (input hidden): ").strip()

    while True:
        show_option = input("Would you like to view the entered password? (y/n): ").strip().lower()
        if show_option == 'y':
            print(f"Entered Password: {password}")
            break
        elif show_option == 'n':
            break
        else:
            print("Please enter 'y' or 'n'.")

    if username in users and users[username]['password'] == password:
        print(f"\nWelcome, {username}!")
        pause()
        user_session(users, username)
    else:
        print("Invalid username or password.")
        pause()

def user_session(users, username):
    while True:
        print_header()
        print(f"Logged in as: {username}")
        print("1. Command Prompt")
        print("2. Task Manager")
        print("3. Web Browser")
        print("4. Settings Menu")
        print("5. Search Settings")
        print("6. App Store")
        print("7. Reset Password")
        print("8. Update Username")
        print("9. View-Only Python Script")  # Added this option
        print("10. Logout")
        choice = input("Select an option (1-10): ").strip()
        if choice == '1':
            command_prompt()
        elif choice == '2':
            task_manager()
        elif choice == '3':
            open_browser()
        elif choice == '4':
            settings_menu(users, username)
        elif choice == '5':
            search_settings(users, username)
        elif choice == '6':
            app_store()
        elif choice == '7':
            reset_password(users, username)
        elif choice == '8':
            username = update_username(users, username)
        elif choice == '9':
            display_view_only_script()
        elif choice == '10':
            print("Logging out...")
            pause()
            break
        else:
            print("Invalid choice.")
            pause()

def display_view_only_script():
    # This is the code that will be displayed as the "view-only" script
    code = '''import os
import sys

def list_files():
    print("Listing files in current directory:")
    for filename in os.listdir('.'):
        print(f" - {filename}")

def open_notepad():
    try:
        if os.name == 'nt':
            os.startfile('notepad.exe')
        else:
            subprocess.call(['nano'])
    except Exception as e:
        print(f"Error opening editor: {e}")

def show_system_info():
    print("System Information:")
    if os.name == 'nt':
        os.system('systeminfo')
    else:
        os.system('uname -a')

def main():
    print("Welcome to the Read-Only System Utility.")
    print("This script is for viewing and basic usage only.")
    while True:
        print("\\nOptions:")
        print("1. List files")
        print("2. Open Notepad")
        print("3. Show system info")
        print("4. Exit")
        choice = input("Enter choice (1-4): ").strip()
        if choice == '1':
            list_files()
        elif choice == '2':
            open_notepad()
        elif choice == '3':
            show_system_info()
        elif choice == '4':
            print("Exiting. Have a nice day!")
            break
        else:
            print("Invalid choice. Please select 1-4.")

if __name__ == "__main__":
    main()
'''
    print("\n--- View-Only Python Script ---\n")
    print(code)
    print("\nYou can copy, run, but not edit this script.")
    pause()

# The rest of your functions (update_username, command_prompt, task_manager, etc.) remain unchanged
# (They are already included above in your full code; make sure to keep your entire script intact)

# Main loop
if __name__ == '__main__':
    users = load_users()
    current_username = None
    while True:
        print_header()
        print("Main Menu")
        print("1. Register")
        print("2. Login")
        print("3. Exit")
        print("4. Settings")  # Optional: direct access if logged in
        choice = input("Select (1-4): ").strip()
        if choice == '1':
            users = register_user(users)
        elif choice == '2':
            def login_user_return():
                print_header()
                print("Login")
                username = input("Username: ").strip()
                password = getpass.getpass("Password (input hidden): ").strip()

                while True:
                    show_option = input("Would you like to view the entered password? (y/n): ").strip().lower()
                    if show_option == 'y':
                        print(f"Entered Password: {password}")
                        break
                    elif show_option == 'n':
                        break
                    else:
                        print("Please enter 'y' or 'n'.")
                if username in users and users[username]['password'] == password:
                    print(f"\nWelcome, {username}!")
                    pause()
                    return username
                else:
                    print("Invalid username or password.")
                    pause()
                    return None
            current_username = login_user_return()
        elif choice == '3':
            print("Goodbye!")
            break
        elif choice == '4':
            if current_username:
                # Direct access to settings
                settings_menu(users, current_username)
            else:
                print("Please login first.")
                pause()
